---
description: "Learn more about: New DAX functions"
title: "New DAX functions | Microsoft Docs"
---
# New DAX functions

DAX is continuously being improved with new functions and functionality to support new features. New functions and updates are included in service, application, and tool updates which in most cases are monthly.

While functions and functionality are being updated all the time, only those updates that have a visible and functional change exposed to users are described in documentation. New functions and updates to existing functions within the past year are shown here.

> [!IMPORTANT]
> Not all functions are supported in all versions of Power BI Desktop, Analysis Services, and Power Pivot in Excel. New and updated functions are typically first introduced in Power BI Desktop, and then later in Analysis Services, Power Pivot in Excel, and tools.
  
## New functions

|Function  |Month  | Description |
|---------|---------|---------|
|[FIRST](first-function-dax.md)|January, 2024|Used in visual calculations only. Retrieves a value in the visual matrix from the first row of an axis.|
|[LAST](last-function-dax.md)|January, 2024|Used in visual calculations only. Retrieves a value in the visual matrix from the last row of an axis.|
|[NEXT](next-function-dax.md)|January, 2024|Used in visual calculations only. Retrieves a value in the next row of an axis in the visual matrix.|
|[PREVIOUS](previous-function-dax.md)|January, 2024|Used in visual calculations only. Retrieves a value in the previous row of an axis in the visual matrix. |
|[MATCHBY](matchby-function-dax.md)|May, 2023|Define the columns that are used to to match data and identify the current row, in a window function expression.|
|[RANK](rank-function-dax.md)|April, 2023|Returns the ranking for the current context within the specified partition, sorted by the specified order.|
|[ROWNUMBER](rownumber-function-dax.md)|April, 2023|Returns the unique ranking for the current context within the specified partition, sorted by the specified order.|
|[LINEST](linest-function-dax.md)|February, 2023|Uses the Least Squares method to calculate a straight line that best fits the given data.|
|[LINESTX](linestx-function-dax.md)|February, 2023|Uses the Least Squares method to calculate a straight line that best fits the given data. The data result from expressions evaluated for each row in a table.|
